//
//  GreenViewController.swift
//  TabControllerDemo
//
//  Created by Sakib Miazi on 6/6/23.
//

import UIKit

class GreenViewController: UIViewController {
    let greenView = GreenView()
    
    let notificationCenter = NotificationCenter.default
    
    override func loadView() {
        view = greenView
    }
    override func viewDidLoad() {
        super.viewDidLoad()
        view.backgroundColor = .white
        title = "Green"
        
        //MARK: setting observers...
        observeBlue()
        observeRed()

        //MARK: send hello button...
        greenView.buttonSend.addTarget(self, action: #selector(onButtonSendTapped), for: .touchUpInside)
    }
    
    //MARK: observing blue...
    func observeBlue(){
        notificationCenter.addObserver(
            self,
            selector: #selector(notificationReceived(notification:)),
            name: .fromBlue, object: nil
        )
    }

    //MARK: observing red...
    func observeRed(){
        notificationCenter.addObserver(
            self,
            selector: #selector(notificationReceived(notification:)),
            name: .fromRed, object: nil
        )
    }

    //MARK: handling notifications...
    @objc func notificationReceived(notification: Notification){
        greenView.labelReceived.text = notification.object as! String
    }

    //MARK: sending hello to other screens...
    @objc func onButtonSendTapped(){
        notificationCenter.post(
            name: .fromGreen,
            object: "Hello from Green!"
        )
    }
}
